ORCA/M Asm65816 2.1.0

0001 7600                       TITLE 'Monitor Dispatcher'
0002 7600
0003 7600              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 7600              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 3:27:51 PM
0005 7600
0006 7600              ******************************************************
0007 7600              *                                                    *
0008 7600              *             Monitor Bank $FF Dispatcher            *
0009 7600              *                                                    *
0010 7600              *                    by                              *
0011 7600              *               Fern Bachman     1985-1987           *
0012 7600              *               Joe Bo           1987-1989           *
0013 7600              *                                                    *
0014 7600              *       Copyright Apple Computer, Inc. 1985-1989     *
0015 7600              *                All Rights Reserved.                *
0016 7600              *                                                    *
0017 7600              ******************************************************
0018 7600
0019 7600
0020 7600                                                      ; SEG $FF
0021 7600              SPELRESET EQU   *                       ;Special call from NEWRESET, int off here
0022 7600                                                      ; SEG $00
0023 7600 8F 00 01 01           STA   >MNEMSTKPTR              ;Dummy up int stack pointers
0024 7604 8F 01 01 01           STA   >ALEMSTKPTR              ;  in case user forgets too.
0025 7608 C2 20                 REP   #$20                     ;16 bit 'm'
0026 760A                       LONGA ON
0027 760A A9 76 FF              LDA   #>MONPATCH               ;Set up monitor dispatcher
0028 760D 8F 9A 01 E1           STA   >MDISPATCH+2             ;
0029 7611 A9 5C 29              LDA   #MONPATCH*256+$5C        ;Low word of dispatcher & Jmp abslong
0030 7614 8F 98 01 E1           STA   >MDISPATCH               ;
0031 7618
0032 7618 A9 A9 FF              LDA   #>TOMAINSIDE1            ;Set up mainside dispatcher
0033 761B 8F 9E 01 E1           STA   >MAINSIDEPATCH+2         ;
0034 761F A9 5C AA              LDA   #TOMAINSIDE1*256+$5C     ;
0035 7622 8F 9C 01 E1           STA   >MAINSIDEPATCH           ;
0036 7626 E2 20                 SEP   #$20                     ;Back to 8 bit mode
0037 7628                       LONGA OFF
0038 7628 6B                    RTL                            ;Return to NEWRESET routine
0039 7629
0040 7629                                                      ; SEG $FF
0041 7629              MONPATCH EQU   *
0042 7629                                                      ; SEG $00
0043 7629
0044 7629                       LONGA OFF
0045 7629                       LONGI OFF
0046 7629 AD 15 C0              LDA   RDCXROM                  ;Get current CxROM state
0047 762C 48                    PHA                            ; and save for exiting.
0048 762D 8D 07 C0              STA   SETINTCXROM              ;MUST enable internal CxROM for routines
0049 7630 F4 93 76              PEA   FFEXIT-1                 ;Assures common exit point from bank FF
0050 7633 98                    TYA                            ;Make correct index
0051 7634 30 30                 BMI   @2                       ;Bit 7=1 for 2nd dispatch table
0052 7636
0053 7636 08                    PHP                            ;Save c status
0054 7637 C9 05                 CMP   #$05                     ;0-4 then special entry
0055 7639 B0 04                 BCS   @1                       ;
0056 763B 0A                    ASL   A                        ;Y * 2 for correct indexing
0057 763C 28                    PLP                            ;Restore status
0058 763D 80 17                 BRA   @0                       ;
0059 763F
0060 763F              @1       EQU   *
0061 763F 28                    PLP                            ;Restore c status
0062 7640
0063 7640              * If any of 5 bits in $4FB (MODE) is on, then the mode is not
0064 7640              * valid for video firmware.  Use old routines.
0065 7640
0066 7640 AD FB 04              LDA   MODE                     ;no, is mode valid?
0067 7643 29 D6                 AND   #M_PASCAL+M_6+M_4+M_2+M_1
0068 7645 08                    PHP                            ;Save status of 'AND'
0069 7646 98                    TYA                            ;80 column routines in 2nd half of table
0070 7647 0A                    ASL   A                        ; Y*2 = correct index
0071 7648 28                    PLP                            ;Restore status of 'AND'
0072 7649 D0 0B                 BNE   @0                       ;=>no, use 40 column routines
0073 764B 18                    CLC                            ;
0074 764C 69 1E                 ADC   #TABLEN
0075 764E 48                    PHA   
0076 764F 20 73 C9              JSR   CSETUP                   ;set up 80 column cursor
0077 7652 20 97 CD              JSR   VTABC                    ;calc base
0078 7655 68                    PLA   
0079 7656
0080 7656              @0       EQU   *
0081 7656 9B                    TXY                            ;MUST save and restore X
0082 7657 AA                    TAX                            ;Move index to X
0083 7658 BF 77 76 FF           LDA   >DISPATCHTBL+1,X         ;Use RTS info to go to subroutine
0084 765C 48                    PHA                            ;
0085 765D BF 76 76 FF           LDA   >DISPATCHTBL+0,X         ;
0086 7661
0087 7661              @11      EQU   *
0088 7661 48                    PHA                            ;
0089 7662 BB                    TYX                            ;Now restore X
0090 7663 A3 0A                 LDA   10,S                     ; and A too!
0091 7665 60                    RTS                            ;Off to routine
0092 7666
0093 7666              @2       EQU   *
0094 7666 08                    PHP                            ;MUST preserve C/V statuses
0095 7667 0A                    ASL   A                        ; Y*2 = correct index
0096 7668 28                    PLP                            ;Restore C/V statuses
0097 7669 9B                    TXY                            ;MUST save and restore X
0098 766A AA                    TAX                            ;Move index to X
0099 766B BF B3 76 FF           LDA   >DISPATCHTBL2+1,X        ;Use RTS info to go to subroutine
0100 766F 48                    PHA                            ;
0101 7670 BF B2 76 FF           LDA   >DISPATCHTBL2+0,X        ;
0102 7674 80 EB                 BRA   @11                      ;
0103 7676                                                      ; SEG $FF
0104 7676
0105 7676              DISPATCHTBL EQU   *
0106 7676 4F C8                 DC W:BOUT-1                    ;(0) 80 column output 
0107 7678 13 B4                 DC W:B_ESCFIX-1                ;(1) ESCFIX
0108 767A 0D B4                 DC W:F_BASCALCCC-1             ;(2) BASCALCCC
0109 767C 4A B4                 DC W:B_KEYIN-1                 ;(3) KEYIN
0110 767E 44 B4                 DC W:F_VTABCZ-1                ;(4) VTABCZ 
0111 7680 74 B3                 DC W:F_HOME-1                  ;(5) 40 column HOME
0112 7682 8F B3                 DC W:F_SCROLL-1                ;(6) 40 column scroll
0113 7684 32 B4                 DC W:F_CLREOL-1                ;(7) 40 column clear line
0114 7686 CA B3                 DC W:F_CLREOLZ-1               ;(8) 40 column clear with Y set
0115 7688 6F B4                 DC W:B_RESETX-1                ;(9) 40/80 column reset
0116 768A 7A B3                 DC W:F_CLREOP-1                ;(A) 40 column clear end of page
0117 768C 00 B4                 DC W:F_RDKEY-1                 ;(B) readkey w/flashing checkerboard
0118 768E BD B3                 DC W:F_SETWND-1                ;(C) Set 40 column window 
0119 7690 2C B4                 DC W:FIXPICK-1                 ;(D) fix pick for 80 columns
0120 7692 EC B3                 DC W:F_QUIT-1                  ;(E) quit before IN#0,PR#0
0121 7694
0122 7694              TABLEN   EQU   *-DISPATCHTBL
0123 7694                                                      ; SEG $00
0124 7694              FFEXIT   EQU   *
0125 7694 83 06                 STA   6,S                      ;Save 'A' for user's calling routine
0126 7696 68                    PLA                            ;Recall state of CxROM
0127 7697 30 03                 BMI   @1                       ;Bit7=1 if was internal CX space
0128 7699 8D 06 C0              STA   SETSLOTCXROM             ; else enable external CX space
0129 769C              @1       EQU   *
0130 769C 6B                    RTL                            ;Back to caller
0131 769D 00                    DC B:$00                       ;Make FFEXIT 10 bytes long (A MUST!)
0132 769E                                                      ; SEG $FF
0133 769E
0134 769E D3 B3                 DC W:B_HOME-1                  ;(5) 80 column HOME
0135 76A0 83 CB                 DC W:SCROLLUP-1                ;(6) 80 column scroll
0136 76A2 3F CC                 DC W:X_GS-1                    ;(7) 80 column clear line
0137 76A4 CE B3                 DC W:B_CLREOLZ-1               ;(8) 80 column clear with Y set
0138 76A6 6F B4                 DC W:B_RESETX-1                ;(9) 40/80 column reset
0139 76A8 1A CC                 DC W:X_VT-1                    ;(A) 80 column clear end of page
0140 76AA 97 B4                 DC W:B_RDKEYX-1                ;(B) readkey w/inverse cursor
0141 76AC 5F B4                 DC W:B_SETWNDX-1               ;(C) 40/80 column VTABC
0142 76AE 2C B4                 DC W:FIXPICK-1                 ;(D) fix pick for 80 columns
0143 76B0 E1 B3                 DC W:B_QUIT-1                  ;(E) quit before IN#0,PR#0
0144 76B2
0145 76B2
0146 76B2              DISPATCHTBL2 EQU   *
0147 76B2 03 AA                 DC W:XMEMORY-1                 ;(80) Examine memory display
0148 76B4 7A B8                 DC W:XSEARCH-1                 ;(81) Pattern search
0149 76B6 C3 B4                 DC W:XMOVE1-1                  ;(82) Move data
0150 76B8 60 B7                 DC W:XVFY-1                    ;(83) Verify data
0151 76BA 8A B0                 DC W:MINIFF-1                  ;(84) Activate miniassembler
0152 76BC C5 B2                 DC W:XSTOR-1                   ;(85) Store byte routine
0153 76BE 5F 9D                 DC W:TRACEFF-1                 ;(86) Trace
0154 76C0 6E 9D                 DC W:STEPFF-1                  ;(87) Step
0155 76C2 14 A7                 DC W:RESUMEFF-1                ;(88) Resume command
0156 76C4 D5 A2                 DC W:EQUALSFF-1                ;(89) '=' delimiter
0157 76C6 5A AB                 DC W:LISTFF-1                  ;(8A) Disassem and show 20 instructions
0158 76C8 40 B8                 DC W:SETPTRN-1                 ;(8B) Set up pattern for search
0159 76CA A3 B4                 DC W:ZMEMORY-1                 ;(8C) Zap memory
0160 76CC BE B0                 DC W:LITERALASC-1              ;(8D) Literal ASCII input mode
0161 76CE 2E A7                 DC W:GO816FF-1                 ;(8E) JSR SUBR and return to monitor
0162 76D0 1E A7                 DC W:X816FF-1                  ;(8F) JSL SUBR and return to monitor
0163 76D2 51 A8                 DC W:UTILITYFF-1               ;(90) Utility call to Tool Locator
0164 76D4 F3 9B                 DC W:MAKEMXE0-1                ;(91) Switch internal 'm'/'x'/'e' to 0
0165 76D6 6E 79                 DC W:ENMONDSKACC-1             ;(92) Enable monitor desk accessory
0166 76D8 08 A4                 DC W:DECDISASM-1               ;(93) Disasm break/registers
0167 76DA 6F B2                 DC W:XGETNUM-1                 ;(94) New GETNUM routine for monitor
0168 76DC FF 9B                 DC W:PREADFF-1                 ;(95) New monitor PREAD routine
0169 76DE 36 9B                 DC W:REGSETFF-1                ;(96) Setup regs for monitor entry at MON
0170 76E0 95 AC                 DC W:XINSDS1-1                 ;(97) Instruction display 
0171 76E2 82 A5                 DC W:NODISK2-1                 ;(98) No disk to boot from
0172 76E4 2B AD                 DC W:DISASEM-1                 ;(99) Disassemble 1 inst (for step/trace)
0173 76E6 9B AC                 DC W:INSDS3-1                  ;(9A) Get length of 65816 instruction
0174 76E8 9A C9                 DC W:DECCHFF-1                 ;(9B) Decrement all CH's
0175 76EA A3 C9                 DC W:WDTCHFF-1                 ;(9C) Width - 1 for all CH's
0176 76EC BE 9C                 DC W:RAMVCTRS-1                ;(9D) Some additional coldstart stuff
0177 76EE 50 9A                 DC W:NEWBELL1-1                ;(9E) New BELL1 routine for 40/80 columns
0178 76F0 EF AA                 DC W:GET6502LEN-1              ;(9F) Get length of 6502 instructions only
0179 76F2 57 9A                 DC W:NEWBELL2-1                ;(A0) Use speaker for BELL1 routine
0180 76F4 78 A6                 DC W:MATH-1                    ;(A1) Do 32 bit math
0181 76F6 F7 A9                 DC W:ENTER80-1                 ;(A2) Enter 80 columns with ctrl-x in 'A'
0182 76F8 CE BA                 DC W:SETUPBR-1                 ;(A3) Read and setup BATTERYRAM parameters
0183 76FA F2 7B                 DC W:SPLASH-1                  ;(A4) Display splash screen
0184 76FC EC A4                 DC W:REGDSP2-1                 ;(A5) Display registers
0185 76FE 01 8F                 DC W:TEXT2COPYFF-1             ;(A6) Text page 2 copy from bank 00 to e1
0186 7700 2D 7A                 DC W:SETTEXT2REG-1             ;(A7) Set textp2 shadow bit ($c035, bit5)
0187 7702 23 7C                 DC W:APPLEIIGSMSG-1            ;(A8) Display Apple IIgs as title
0188 7704 FF A7                 DC W:SETPAG1-1                 ;(A9) Toggle txtpag1 & the one prior 'BRK'
0189 7706 F3 A7                 DC W:TEXTPAGE1-1               ;(AA)
0190 7708                                                      ; SEG $00
0191 7708
